/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: AsiApm_Functionlist.h $
   Last Modification:
    $Id: AsiApm_Functionlist.h 6674 2010-03-22 10:23:37Z AndreasB $

    $Author: Eric $
    $Modtime: 27.08.08 8:57 $
    $Revision: 0 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
     1          15.01.09    ES
        Created

**************************************************************************************/
/**
 * @file AsiApm_Functionlist.h
 * @brief AS-Interface Apm - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_AsiApm</code>
 * of task.
 */
#ifndef __ASI_APM_FUNCTIONLIST_H
#define __ASI_APM_FUNCTIONLIST_H

/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_AsiApm
(
TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskLeave_AsiApm
(
TLR_VOID FAR* pvRsc,
TLR_VOID FAR* pvLve
);

TLR_VOID
TaskEnter_AsiApm
(
TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define ASI_APM_STARTUP_PARAM_VERSION_1 (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** LED instance */
typedef struct ASI_APM_LED_CONFIG_Ttag ASI_APM_LED_CONFIG_T;

struct ASI_APM_LED_CONFIG_Ttag
{
  STRING     szName[16];
  TLR_UINT32 ulLedInst;
};

/** task startup parameter */
typedef struct ASI_APM_STARTUPPARAMETER_Ttag  ASI_APM_STARTUPPARAMETER_T;

#define ASI_APM_STA_LED_NAME   "ASI_STA"   /* Default name for AS-Interface status LED */
#define ASI_APM_ERR_LED_NAME   "ASI_ERR"   /* Default name for AS-Interface error LED  */

#define ASI_APM_MIN_CYCLETIME  1
#define ASI_APM_DEF_CYCLETIME  10
#define ASI_APM_MAX_CYCLETIME  100

#define ASI_APM_CHN_INST_0   0
#define ASI_APM_CHN_INST_1   1
#define ASI_APM_CHN_INST_2   2
#define ASI_APM_CHN_INST_3   3

#define ASI_APM_QUEUE_MIN_ELEM 8
#define ASI_APM_QUEUE_DEF_ELEM 32
#define ASI_APM_QUEUE_MAX_ELEM 64

#define ASI_APM_POOL_MIN_ELEM  8
#define ASI_APM_POOL_DEF_ELEM  32
#define ASI_APM_POOL_MAX_ELEM  64

/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */

struct ASI_APM_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;
  /** Cycle Time*/
  TLR_UINT32 ulCycleTime;
  /** Channel instance*/
  TLR_UINT32 ulChnInst;
  /** Queue element count*/
  TLR_UINT32 ulQueueElem;
  /** Pool element count*/
  TLR_UINT32 ulPoolElem;
  /** Status LED*/
  ASI_APM_LED_CONFIG_T tStaLed;
  /** Error LED*/
  ASI_APM_LED_CONFIG_T tErrLed;
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __ASI_APM_FUNCTIONLIST_H */

/*************************************************************************************/
/*-----------------------------------------------------------------------------------*/
/*-------------------------- EOF ----------------------------------------------------*/
/*-----------------------------------------------------------------------------------*/
/*************************************************************************************/

